#!/bin/bash

if [ "$#" -ne 2 ]; then
    echo "Uso: $0 <Novo_IP> <Novo_Hostname>"
    exit 1
fi

NOVO_IP=$1
NOVO_HOSTNAME=$2
CONFIG_FILE="/etc/zabbix/zabbix_agent2.conf"

rpm -Uvh http://repo.zabbix.com/zabbix/7.0/rhel/7/x86_64/zabbix-release-latest.el7.noarch.rpm

sed -i 's/enabled=1/enabled=0/g' /etc/yum.repos.d/zabbix.repo
sed -i 's/https/http/g' /etc/yum.repos.d/zabbix.repo

echo "instalando zabbix-agent2..."
yum -y -q install --enablerepo=zabbix zabbix-agent2 zabbix-agent2-plugin-* zabbix-get zabbix-sender

echo "Configurando..."
sed -i "s/^Server=.*/Server=$NOVO_IP/" "$CONFIG_FILE"
sed -i "s/^Hostname=.*/Hostname=$NOVO_HOSTNAME/" "$CONFIG_FILE"
sed -i "s/^ServerActive=.*/#&/" "$CONFIG_FILE"

echo "Configurações atualizadas com sucesso no arquivo $CONFIG_FILE:"
echo "Server=$NOVO_IP"
echo "Hostname=$NOVO_HOSTNAME"

systemctl start zabbix-agent2
systemctl enable zabbix-agent2
echo "Instalação Concluida"
